/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.utils;

import android.hardware.usb.UsbDevice;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SDKUtils {
    public static boolean checkUsbDevicePidVid(UsbDevice dev) {
        if (dev == null) {
            return false;
        }
        int pid = dev.getProductId();
        int vid = dev.getVendorId();
        boolean rel = false;
        if (vid == 34918 && pid == 256 || vid == 1137 && pid == 85 || vid == 6790 && pid == 30084 || vid == 26728 && pid == 256 || vid == 26728 && pid == 512 || vid == 26728 && pid == 256 || vid == 26728 && pid == 768 || vid == 26728 && pid == 1024 || vid == 26728 && pid == 1280 || vid == 26728 && pid == 1536 || vid == 7358 && pid == 2) {
            rel = true;
        }
        return rel;
    }

    public static byte[] convertVectorByteToBytes(Vector<Byte> data) {
        byte[] sendData = new byte[data.size()];
        if (data.size() > 0) {
            for (int i = 0; i < data.size(); ++i) {
                sendData[i] = data.get(i);
            }
        }
        return sendData;
    }

    public static List<byte[]> getListByteArray(byte[] bytes, int counts) {
        ArrayList<byte[]> lists = new ArrayList<byte[]>();
        int f = bytes.length / counts;
        int length = 0;
        for (int i = 0; i < f; ++i) {
            byte[] bbb = new byte[counts];
            for (int j = 0; j < counts; ++j) {
                bbb[j] = bytes[j + i * counts];
            }
            length += bbb.length;
            lists.add(bbb);
        }
        if (length < bytes.length) {
            byte[] a = new byte[bytes.length - length];
            for (int i = 0; i < bytes.length - length; ++i) {
                a[i] = bytes[length + i];
            }
            lists.add(a);
        }
        return lists;
    }

    public static byte[] subBytes(byte[] src, int begin, int count) {
        byte[] bs = new byte[count];
        System.arraycopy(src, begin, bs, 0, count);
        return bs;
    }

    public static byte[] addBytes(byte[] data1, byte[] data2) {
        byte[] data3 = new byte[data1.length + data2.length];
        System.arraycopy(data1, 0, data3, 0, data1.length);
        System.arraycopy(data2, 0, data3, data1.length, data2.length);
        return data3;
    }

    public static boolean checkPairCode(String pairCode) {
        return pairCode.matches("^\\d{4}$");
    }

    public static boolean checkIP(String addr) {
        if (addr.length() < 7 || addr.length() > 15 || "".equals(addr)) {
            return false;
        }
        String rexp = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
        Pattern pat = Pattern.compile(rexp);
        Matcher mat = pat.matcher(addr);
        boolean ipAddress = mat.find();
        if (ipAddress) {
            String[] ips = addr.split("\\.");
            if (ips.length == 4) {
                try {
                    for (String ip : ips) {
                        if (Integer.parseInt(ip) >= 0 && Integer.parseInt(ip) <= 255) continue;
                        return false;
                    }
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            }
            return false;
        }
        return ipAddress;
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            stringBuilder.append(String.format("%02X ", src[i]));
        }
        return stringBuilder.toString();
    }
}

